

#define shellundoinclude /*so other includes can tell if we've been loaded*/




typedef struct tystack {

	short topstack;

	short basesize;

	short elemsize;
	
	#if THINK_C
		
		byte stack [];
	
	#else
			
		byte stack [1];
	
	#endif	
	} tystack, *ptrstack, **hdlstack;


typedef boolean (*undocallback) (Handle, boolean);


typedef struct tyundorecord {
	
	undocallback undoroutine;
	
	Handle hundodata;
	
	boolean flactionstep; /*is this step an action record?*/
	} tyundorecord;


typedef struct tyactionrecord {
	
	long ixaction;
	
	long globaldata;
	
	boolean flaction; /*always true for actionrecords*/
	} tyactionrecord;


typedef struct tyundostack {

	short topundo;
	
	short basesize;
	
	short elemsize;
	
	/*
	union {
		tyundorecord undostep;
		
		tyactionrecord actionstep;
		} u;
	*/
		
	short ixaction;
	
	long globaldata;
	
	#if THINK_C
		
		tyundorecord undostep [];
	
	#else
	
		tyundorecord undostep [1];
		
	#endif
	} tyundostack, *ptrundostack, **hdlundostack;


/*function prototypes*/

extern boolean pushundostep (undocallback, Handle);

extern boolean pushundoaction (short);

extern boolean popundoaction (void);

extern boolean undolastaction (boolean);

extern boolean redolastaction (boolean);

extern boolean getundoaction (short *);

extern boolean getredoaction (short *);

extern void killundo (void);

extern boolean newundostack (hdlundostack *);

extern boolean disposeundostack (hdlundostack);

extern void initundo (void);


/*global variables*/

extern hdlundostack shellundostack;

extern hdlundostack shellredostack;


